unit memory; 
interface
uses Crt;

const LENGTH = 200;
type Tmem_reg = ^Tmem_elem;
     Tmem_elem = record 
                   bgn : integer;
                   num : integer;
                   nxt : Tmem_reg;
                end;
var ErrCode : integer;                
    ram : array [1..LENGTH] of integer;
    mem : Tmem_reg;  
    
procedure MemInit;  
procedure MemDrop; 
procedure MemAdd (kiek : integer);
procedure MemList;
procedure MemShow;
procedure MemFree (kur : integer);
procedure MemPress;
procedure new_win (x1, y1, x2, y2, borc, Bc, Tc : integer; txt : string);
procedure WinClear (col : integer); 
procedure Key (var cha : integer);
procedure Digit (var cha : integer);

            
implementation
{Nuskaito skaiciu *************************************************************}
procedure Digit (var cha : integer);
   var tmp, sk : integer;
   begin
      tmp := 0;
      sk := 0;
      while sk + 48 <> 13 do
         begin 
           sk := ord(readkey);
           sk := sk - 48;
           if (sk >= 0) and (sk <= 9) then
              begin
                 tmp := (tmp * 10) + sk;
                 write (sk);
              end;                         
         end;
      cha := tmp;         
   end; 
{Nuskaito klavisa *************************************************************}
procedure key (var cha : integer);
   begin
      cha := ord(readkey) - 48;
      while (cha < 0) or (cha > 9) do 
         cha := ord(readkey) - 48;
      writeln (cha);
   end;
{Isvalo atminti nurodyta spalva ***********************************************}
procedure WinClear (col : integer);
   begin
      TextBackground (col);
      ClrScr;
   end;
   
{Sukompresuoja atminti ********************************************************}   
procedure MemPress;
   var tmp, tmp2 : Tmem_reg;
       i : integer;
   begin
      tmp := mem;
      tmp^.bgn := 1;
      tmp :=tmp^.nxt;
      tmp2 := mem;
      while tmp <> nil do
         begin
            tmp^.bgn := tmp2^.bgn + tmp2^.num;
            tmp := tmp^.nxt;
            tmp2 := tmp2^.nxt;
         end; 
      for i := 1 to LENGTH do 
         ram[i] := 0;
      tmp := mem;   
      while tmp <> nil do
         begin
            for i := tmp^.bgn to tmp^.bgn + tmp^.num - 1 do
               ram [i] := 1; 
            tmp := tmp^.nxt;
         end;       
   end;
{Paruosia ir apnulina atminti *************************************************}
procedure MemInit;
   var i : integer;
   begin
      for i := 1 to LENGTH do
         ram[i] := 0;
      mem := nil;
      ErrCode := 0;   
   end;
{Atlaisvina atminti ***********************************************************}
procedure MemDrop;
   var tmp : Tmem_reg;
   begin
      while mem <> nil do
         begin
            tmp := mem;
            mem := mem^.nxt;
            Dispose (tmp);
         end;
   end;
{Ideda nauja elementa i saras *************************************************}
procedure MemAdd (kiek : integer);
   var tmp, ptr : Tmem_reg;
       i, cnt : integer;
   begin
      ErrCode := 0;
      cnt := 0;
      for i := 1 to LENGTH do
         begin 
            if ram[i] = 1 then cnt := 0;
            if ram[i] = 0 then cnt := cnt + 1; 
            if cnt >= kiek then Break;
         end;
      if (i = LENGTH) and (cnt < kiek) then 
         begin
            ErrCode := 1;
            Exit;   
         end; 
      if mem <> nil then 
         begin   
            ptr := mem;    
            while ptr^.nxt <> nil do
               ptr := ptr^.nxt;
            New (tmp);
            if tmp = nil then 
               begin
                  ErrCode := 1;
                  Exit;   
               end;
            tmp^.num := kiek;
            tmp^.nxt := nil;
            tmp^.bgn := i - kiek + 1;
            ptr^.nxt := tmp;
            for i := tmp^.bgn to tmp^.bgn + kiek - 1 do
               ram[i] := 1;
         end
      else 
         begin
            new (mem);
            mem^.nxt := nil;
            mem^.bgn := 1;
            mem^.num := kiek;
            for i := 1 to kiek do
               ram[i] := 1;
         end;
          
   end;
{Pavaizduoja atminti sarasu ***************************************************}
procedure MemList;
var tmp : Tmem_reg;
    i : integer;
    begin
       i := 0;
       tmp := mem;
       while tmp <> nil do
          begin
             i := i + 1;
             Writeln (i, ' Atmintis nuo: ', tmp^.bgn, ' Uzima: ', tmp^.num);
             tmp := tmp^.nxt;
          end;
    end;  
    
{Pavaizduoja atminti grafiskai ************************************************}
procedure MemShow;
var tmp : Tmem_reg;
    i : integer;
   begin
      writeln ('Grafiskai atmintis atrodo taip:');
      for i := 1 to LENGTH do
         begin
            if ram[i] = 1 then write (#219);
            if ram[i] = 0 then write ('_');
         end;       
   end;
{Atlaisvina nurodyta atminti **************************************************}

procedure MemFree (kur : integer); 
   var i : integer;
       tmp, tmp2 : Tmem_reg;
   begin
      ErrCode := 0;
      tmp := mem;
      i := 1;
      if (kur < 1) or (mem = nil) then 
         begin
            ErrCode := 1;
            exit;    
         End;
               
      while (i < kur) and (tmp^.nxt <> nil) do
         begin 
           i := i + 1;
           tmp := tmp^.nxt;
         end;
      if kur > i then 
         begin
            ErrCode := 1;
            Exit;          
         end;   
      if kur = 1 then 
         begin
            mem := mem^.nxt;
            for i := tmp^.bgn to tmp^.bgn + tmp^.num-1 do
               ram[i] := 0;
            dispose (tmp);           
            exit;
         end;
      tmp := mem;   
      for i := 1 to kur - 2 do
        tmp := tmp^.nxt;
      tmp2 := tmp^.nxt;
      tmp^.nxt := tmp2^.nxt;
      for i := tmp2^.bgn to tmp2^.bgn + tmp2^.num-1 do
         ram[i] := 0;
      dispose (tmp2);
   end;
   
procedure new_win (x1, y1, x2, y2, borc, Bc, Tc : integer; txt : string);
   var i : integer;
   begin
      window (x1, y1, x2, y2+1);
      textbackground (bc);
      textcolor (borc);
      gotoxy (1,1);
      write (#201);
      for i := 1 to x2-x1-1 do
      write (#205);
      write (#187);
      for i := 2 to y2-y1  do
      begin
         gotoxy (1,i);
         write (#186);
      end;   
      for i := 2 to y2-y1 do
      begin
         gotoxy (x2-x1+1, i);
         write (#186);
      end;
      write (#200);  
      for i := 1 to x2-x1-1 do
         write (#205);
      write (#188);
      gotoxy (3, 1);
      write (txt,' ');     
      gotoxy (2,2);
      textcolor (tc);
      window (x1+1, y1+1, x2-1, y2-1);
      clrscr;
   end;
end.   
